/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.mccs;

import com.quantumdata.mccs.CommonPanel;
import com.quantumdata.mccs.Constants;
import com.quantumdata.mccs.JTextFieldLimit;
import com.quantumdata.mccs.MCCSGUIFrame;
import com.quantumdata.mccs.VCPCodes;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class DPVLPanel
extends CommonPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final int MONITOR_STATUS = 0;
    private final int PACKET_COUNT = 1;
    private final int MONITOR_X_ORIGIN = 2;
    private final int MONITOR_Y_ORIGIN = 3;
    private final int HEADER_ERR_COUNT = 4;
    private final int BODY_CRC_ERR_COUNT = 5;
    private final int CLIENT_ID = 6;
    private final int LINK_CONTROL = 7;
    private JCheckBox jCheckMonitorReceive;
    private JCheckBox jCheckMonitorDetect;
    private String[] jVideoModeValues;
    private JTextField jTextVideoMode;
    private JTextField jTextVideoModeVal;
    private JTextField jTextPacketCountVal;
    private JButton jSendPacketCountButton;
    private JTextField jTextMonitorXOriginVal;
    private JButton jSendMonitorXOriginButton;
    private JTextField jTextMonitorYOriginVal;
    private JButton jSendMonitorYOriginButton;
    private JTextField jTextHeaderErrCountVal;
    private JButton jSendHeaderErrCountButton;
    private JTextField jTextBodyCRCErrCountVal;
    private JButton jSendBodyCRCErrCountButton;
    private JTextField jTextClientIDVal;
    private JButton jSendClientIDButton;
    private JCheckBox jCheckLinkControl;
    private JButton jSendLinkControlButton;

    public DPVLPanel() {
        super(8);
        this.addMonitorStatus();
        this.addPacketCount();
        this.addMonitorXOrigin();
        this.addMonitorYOrigin();
        this.addHeaderErrCount();
        this.addBodyCRCErrCount();
        this.addClientID();
        this.addLinkControl();
        this.constructPanel();
    }

    private void addMonitorStatus() {
        this.vcpCodes[0] = new VCPCodes("Monitor Status", "B7", "RO", "NC");
        this.jCheckMonitorReceive = Constants.createCheckbox("Monitor is unable to accept another packet");
        this.jCheckMonitorReceive.setEnabled(false);
        this.jCheckMonitorDetect = Constants.createCheckbox("Error detected in the last Header received");
        this.jCheckMonitorDetect.setEnabled(false);
        this.jVideoModeValues = new String[]{"Roaster scan mode", "DPVL mode"};
        this.jTextVideoMode = Constants.createSubFieldNameText("Video Mode:");
        this.jTextVideoModeVal = Constants.createFieldValueText(false);
        this.jTextVideoModeVal.setText(this.jVideoModeValues[0]);
    }

    private void addPacketCount() {
        this.vcpCodes[1] = new VCPCodes("Packet Count", "B8", "R/W", "C");
        this.jTextPacketCountVal = Constants.createFieldValueText(true);
        this.jTextPacketCountVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextPacketCountVal.setText("0000");
        this.jSendPacketCountButton = Constants.createSetButton(this);
    }

    private void addMonitorXOrigin() {
        this.vcpCodes[2] = new VCPCodes("Monitor X Origin", "B9", "R/W", "C");
        this.jTextMonitorXOriginVal = Constants.createFieldValueText(true);
        this.jTextMonitorXOriginVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextMonitorXOriginVal.setText("0000");
        this.jSendMonitorXOriginButton = Constants.createSetButton(this);
    }

    private void addMonitorYOrigin() {
        this.vcpCodes[3] = new VCPCodes("Monitor Y Origin", "BA", "R/W", "C");
        this.jTextMonitorYOriginVal = Constants.createFieldValueText(true);
        this.jTextMonitorYOriginVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextMonitorYOriginVal.setText("0000");
        this.jSendMonitorYOriginButton = Constants.createSetButton(this);
    }

    private void addHeaderErrCount() {
        this.vcpCodes[4] = new VCPCodes("Header Error Count", "BB", "R/W", "C");
        this.jTextHeaderErrCountVal = Constants.createFieldValueText(true);
        this.jTextHeaderErrCountVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextHeaderErrCountVal.setText("0000");
        this.jSendHeaderErrCountButton = Constants.createSetButton(this);
    }

    private void addBodyCRCErrCount() {
        this.vcpCodes[5] = new VCPCodes("Body CRC Error Count", "BC", "R/W", "C");
        this.jTextBodyCRCErrCountVal = Constants.createFieldValueText(true);
        this.jTextBodyCRCErrCountVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextBodyCRCErrCountVal.setText("0000");
        this.jSendBodyCRCErrCountButton = Constants.createSetButton(this);
    }

    private void addClientID() {
        this.vcpCodes[6] = new VCPCodes("Client ID", "BD", "R/W", "C");
        this.jTextClientIDVal = Constants.createFieldValueText(true);
        this.jTextClientIDVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 4));
        this.jTextClientIDVal.setText("0000");
        this.jSendClientIDButton = Constants.createSetButton(this);
    }

    private void addLinkControl() {
        this.vcpCodes[7] = new VCPCodes("Link Control", "BE", "R/W", "NC");
        this.jCheckLinkControl = Constants.createCheckbox("Link shutdown is enabled", this);
        this.jSendLinkControlButton = Constants.createSetButton(this);
    }

    private void constructPanel() {
        this.layout.setHorizontalGroup(this.layout.createParallelGroup(1).add(this.layout.createSequentialGroup().add(36, 36, 36).add(this.layout.createParallelGroup(1).add(this.vcpCodes[0].getNameField(), -2, -1, -2).add(this.vcpCodes[1].getNameField(), -2, -1, -2).add(this.vcpCodes[2].getNameField(), -2, -1, -2).add(this.vcpCodes[3].getNameField(), -2, -1, -2).add(this.vcpCodes[4].getNameField(), -2, -1, -2).add(this.vcpCodes[5].getNameField(), -2, -1, -2).add(this.vcpCodes[6].getNameField(), -2, -1, -2).add(this.vcpCodes[7].getNameField(), -2, -1, -2)).add(20, 20, 20).add(this.layout.createParallelGroup(1).add(this.layout.createSequentialGroup().add(this.jCheckLinkControl).add(24, 24, 24).add(this.jSendLinkControlButton)).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.layout.createSequentialGroup().add(this.jTextVideoMode, -2, -1, -2).add(24, 24, 24).add(this.jTextVideoModeVal, -2, -1, -2)).add(this.jCheckMonitorReceive).add(this.jCheckMonitorDetect))).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.jTextPacketCountVal, -2, 50, -2).add(this.jTextMonitorXOriginVal, -2, 50, -2).add(this.jTextMonitorYOriginVal, -2, 50, -2).add(this.jTextHeaderErrCountVal, -2, 50, -2).add(this.jTextBodyCRCErrCountVal, -2, 50, -2).add(this.jTextClientIDVal, -2, 50, -2)).add(24, 24, 24).add(this.layout.createParallelGroup(1).add(this.jSendClientIDButton).add(this.jSendBodyCRCErrCountButton).add(this.jSendHeaderErrCountButton).add(this.jSendMonitorYOriginButton).add(this.jSendMonitorXOriginButton).add(this.jSendPacketCountButton)))).addContainerGap(161, Short.MAX_VALUE)));
        this.layout.setVerticalGroup(this.layout.createParallelGroup(1).add(this.layout.createSequentialGroup().add(36, 36, 36).add(this.layout.createParallelGroup(3).add(this.vcpCodes[0].getNameField(), -2, -1, -2).add(this.jCheckMonitorDetect)).add(this.jCheckMonitorReceive).add(8, 8, 8).add(this.layout.createParallelGroup(3).add(this.jTextVideoMode, -2, -1, -2).add(this.jTextVideoModeVal, -2, 28, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[1].getNameField(), -2, -1, -2).add(this.jTextPacketCountVal, -2, 28, -2).add(this.jSendPacketCountButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[2].getNameField(), -2, -1, -2).add(this.jTextMonitorXOriginVal, -2, 28, -2).add(this.jSendMonitorXOriginButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[3].getNameField(), -2, -1, -2).add(this.jTextMonitorYOriginVal, -2, 28, -2).add(this.jSendMonitorYOriginButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[4].getNameField(), -2, -1, -2).add(this.jTextHeaderErrCountVal, -2, 28, -2).add(this.jSendHeaderErrCountButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[5].getNameField(), -2, -1, -2).add(this.jTextBodyCRCErrCountVal, -2, 28, -2).add(this.jSendBodyCRCErrCountButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[6].getNameField(), -2, -1, -2).add(this.jTextClientIDVal, -2, 28, -2).add(this.jSendClientIDButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[7].getNameField(), -2, -1, -2).add(this.jCheckLinkControl).add(this.jSendLinkControlButton, -2, 20, -2)).addContainerGap()));
    }

    public void getAllValues(boolean bl, boolean bl2) {
        if (MCCSGUIFrame.allConnected(bl)) {
            this.getMonitorStatus(bl2);
            this.getPacketCount(bl2);
            this.getMonitorXOrigin(bl2);
            this.getMonitorYOrigin(bl2);
            this.getHeaderErrCount(bl2);
            this.getBodyCRCErrCount(bl2);
            this.getClientID(bl2);
            this.getLinkControl(bl2);
            this.revalidate();
        }
    }

    public void refreshPanelContents() {
        boolean bl = this.vcpCodes[0].isSupported();
        this.jCheckMonitorReceive.setEnabled(bl);
        this.jCheckMonitorDetect.setEnabled(bl);
        this.jTextVideoMode.setEnabled(bl);
        this.jTextVideoModeVal.setEnabled(bl);
        bl = this.vcpCodes[1].isSupported();
        this.jTextPacketCountVal.setEnabled(bl);
        this.jSendPacketCountButton.setEnabled(bl);
        bl = this.vcpCodes[2].isSupported();
        this.jTextMonitorXOriginVal.setEnabled(bl);
        this.jSendMonitorXOriginButton.setEnabled(bl);
        bl = this.vcpCodes[3].isSupported();
        this.jTextMonitorYOriginVal.setEnabled(bl);
        this.jSendMonitorYOriginButton.setEnabled(bl);
        bl = this.vcpCodes[4].isSupported();
        this.jTextHeaderErrCountVal.setEnabled(bl);
        this.jSendHeaderErrCountButton.setEnabled(bl);
        bl = this.vcpCodes[5].isSupported();
        this.jTextBodyCRCErrCountVal.setEnabled(bl);
        this.jSendBodyCRCErrCountButton.setEnabled(bl);
        bl = this.vcpCodes[6].isSupported();
        this.jTextClientIDVal.setEnabled(bl);
        this.jSendClientIDButton.setEnabled(bl);
        bl = this.vcpCodes[7].isSupported();
        this.jCheckLinkControl.setEnabled(bl);
        this.jSendLinkControlButton.setEnabled(bl);
    }

    private void getMonitorStatus(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[0], bl) != 0) {
            int n = MCCSGUIFrame.getReadRespSL();
            this.jCheckMonitorDetect.setSelected((n & 4) == 4);
            this.jCheckMonitorReceive.setSelected((n & 2) == 2);
            this.jTextVideoModeVal.setText(this.jVideoModeValues[n & 1]);
        }
    }

    private void getPacketCount(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[1], bl) != 0) {
            this.jTextPacketCountVal.setText(MCCSGUIFrame.getReadRespCurrentValueString());
        }
    }

    private void setPacketCount() {
        MCCSGUIFrame.writeToDisplay(this.vcpCodes[1], this.jTextPacketCountVal.getText());
    }

    private void getMonitorXOrigin(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[2], bl) != 0) {
            this.jTextMonitorXOriginVal.setText(MCCSGUIFrame.getReadRespCurrentValueString());
        }
    }

    private void setMonitorXOrigin() {
        MCCSGUIFrame.writeToDisplay(this.vcpCodes[2], this.jTextMonitorXOriginVal.getText());
    }

    private void getMonitorYOrigin(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[3], bl) != 0) {
            this.jTextMonitorYOriginVal.setText(MCCSGUIFrame.getReadRespCurrentValueString());
        }
    }

    private void setMonitorYOrigin() {
        MCCSGUIFrame.writeToDisplay(this.vcpCodes[3], this.jTextMonitorYOriginVal.getText());
    }

    private void getHeaderErrCount(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[4], bl) != 0) {
            this.jTextHeaderErrCountVal.setText(MCCSGUIFrame.getReadRespCurrentValueString());
        }
    }

    private void setHeaderErrCount() {
        MCCSGUIFrame.writeToDisplay(this.vcpCodes[4], this.jTextHeaderErrCountVal.getText());
    }

    private void getBodyCRCErrCount(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[5], bl) != 0) {
            this.jTextBodyCRCErrCountVal.setText(MCCSGUIFrame.getReadRespCurrentValueString());
        }
    }

    private void setBodyCRCErrCount() {
        MCCSGUIFrame.writeToDisplay(this.vcpCodes[5], this.jTextBodyCRCErrCountVal.getText());
    }

    private void getClientID(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[6], bl) != 0) {
            this.jTextClientIDVal.setText(MCCSGUIFrame.getReadRespCurrentValueString());
        }
    }

    private void setClientID() {
        MCCSGUIFrame.writeToDisplay(this.vcpCodes[6], this.jTextClientIDVal.getText());
    }

    private void getLinkControl(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[7], bl) != 0) {
            this.jCheckLinkControl.setSelected((MCCSGUIFrame.getReadRespSL() & 1) == 1);
        }
    }

    private void setLinkControl() {
        if (this.jCheckLinkControl.isSelected()) {
            MCCSGUIFrame.writeToDisplay(this.vcpCodes[7], 1);
        } else {
            MCCSGUIFrame.writeToDisplay(this.vcpCodes[7], 0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (MCCSGUIFrame.allConnected(true)) {
            if (object == this.jSendPacketCountButton) {
                this.setPacketCount();
            } else if (object == this.jSendMonitorXOriginButton) {
                this.setMonitorXOrigin();
            } else if (object == this.jSendMonitorYOriginButton) {
                this.setMonitorYOrigin();
            } else if (object == this.jSendHeaderErrCountButton) {
                this.setHeaderErrCount();
            } else if (object == this.jSendBodyCRCErrCountButton) {
                this.setBodyCRCErrCount();
            } else if (object == this.jSendLinkControlButton) {
                this.setLinkControl();
            } else if (object == this.jSendClientIDButton) {
                this.setClientID();
            }
        }
    }
}

